/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.awt.Graphics;
import java.awt.Image;
import java.util.Random;
import src.Item;
import src.MinersDelight;
import src.Sprite;

public class Actor {
    public static Random actorR = new Random();
    Image[][] img;
    int x;
    int y;
    int planX;
    int planY;
    double xOffSet = 0.0;
    double yOffSet = 0.0;
    int direction = 2;
    int state = 0;
    int action = 0;
    int actionInfo = 0;
    int health;
    int maxHealth;
    double speed = 0.085;
    private int damage = 1;
    int actSpeed = 25;
    int actSpeedRange = 10;
    int nextAct = 30;
    public boolean Player = false;
    private int drawType = 0;

    public Actor(Image[][] i, int xx, int yy, int h) {
        this.img = i;
        this.x = xx;
        this.planX = xx;
        this.y = yy;
        this.planY = yy;
        this.health = h - 1;
        this.maxHealth = h;
    }

    public void newLoc(int xx, int yy, int d) {
        this.x = xx;
        this.y = yy;
        this.direction = d;
        this.xOffSet = 0.0;
        this.yOffSet = 0.0;
        this.state = 0;
        this.action = 0;
        this.actionInfo = 0;
    }

    public void walk(int d) {
        if (this.action == 0) {
            this.direction = d;
            if (!MinersDelight.isSolid(d, this.x, this.y) && !MinersDelight.actorCollision(this)) {
                this.action = 1;
                int[] locz = MinersDelight.getNewLoc(d, this.x, this.y);
                this.planX = locz[0];
                this.planY = locz[1];
            }
        }
    }

    public void attack(int d) {
        if (this.action != 0) {
            return;
        }
        this.direction = d;
        this.action = 2;
        MinersDelight.damageActor(this);
    }

    public int getDamage() {
        return this.damage;
    }

    public void useItem() {
        int tryuse = MinersDelight.getSolid(this.direction, this.x, this.y);
        int test = MinersDelight.ItemType;
        switch (test) {
            case 1: {
                if (tryuse != 2) break;
                MinersDelight.setSolid(this.direction, this.x, this.y, 0);
                break;
            }
            case 2: {
                if (tryuse == 2 || tryuse == 3) {
                    MinersDelight.setSolid(this.direction, this.x, this.y, 0);
                    break;
                }
                if (tryuse == 5) {
                    MinersDelight.setSolid(this.direction, this.x, this.y, 0);
                    MinersDelight.setItem(this.direction, this.x, this.y, 8);
                    break;
                }
                if (tryuse == 6) {
                    MinersDelight.setSolid(this.direction, this.x, this.y, 0);
                    MinersDelight.setItem(this.direction, this.x, this.y, 6);
                    break;
                }
                if (tryuse != 7) break;
                MinersDelight.setSolid(this.direction, this.x, this.y, 0);
                MinersDelight.setItem(this.direction, this.x, this.y, 7);
            }
        }
    }

    public void aiAct() {
        if (--this.nextAct > 0) {
            return;
        }
        if (this.action != 0) {
            return;
        }
        short min = MinersDelight.pathMap[this.x][this.y];
        int d = -1;
        for (int i = 0; i < 4; ++i) {
            int[] loc = MinersDelight.getNewLoc(i, this.x, this.y);
            if (MinersDelight.pathMap[loc[0]][loc[1]] >= min) continue;
            d = i;
            min = MinersDelight.pathMap[loc[0]][loc[1]];
        }
        if (d == -1 || min > 3) {
            this.walk(actorR.nextInt(4));
            if (this.action == 0) {
                return;
            }
        } else if (min == 0) {
            this.attack(d);
        } else {
            this.walk(d);
        }
        this.nextAct = actorR.nextInt(this.actSpeedRange) + this.actSpeed + 1;
    }

    public void act() {
        switch (this.action) {
            case 1: {
                switch (this.direction) {
                    case 0: {
                        this.yOffSet -= this.speed;
                        this.state = (int)(Math.abs(this.yOffSet) * 8.0 % 4.0);
                        if (!(this.yOffSet <= -1.0)) break;
                        this.yOffSet = 0.0;
                        --this.y;
                        this.action = 0;
                        break;
                    }
                    case 1: {
                        this.xOffSet += this.speed;
                        this.state = (int)(Math.abs(this.xOffSet) * 8.0 % 4.0);
                        if (!(this.xOffSet >= 1.0)) break;
                        this.xOffSet = 0.0;
                        ++this.x;
                        this.action = 0;
                        break;
                    }
                    case 2: {
                        this.yOffSet += this.speed;
                        this.state = (int)(Math.abs(this.yOffSet) * 8.0 % 4.0);
                        if (!(this.yOffSet >= 1.0)) break;
                        this.yOffSet = 0.0;
                        ++this.y;
                        this.action = 0;
                        break;
                    }
                    case 3: {
                        this.xOffSet -= this.speed;
                        this.state = (int)(Math.abs(this.xOffSet) * 8.0 % 4.0);
                        if (!(this.xOffSet <= -1.0)) break;
                        this.xOffSet = 0.0;
                        --this.x;
                        this.action = 0;
                    }
                }
                break;
            }
            case 2: {
                if (this.nextAct >= this.actSpeed / 7 * 6) break;
                this.action = 0;
            }
        }
        if (this.Player) {
            int locType = MinersDelight.itemMap[this.x][this.y];
            if (locType != 0) {
                if (locType == 10) {
                    if (MinersDelight.keyCount > 0) {
                        Item.itemTypes[locType].act();
                        MinersDelight.itemMap[this.x][this.y] = 11;
                    }
                } else if (locType == 13) {
                    if (MinersDelight.keyCount > 1) {
                        Item.itemTypes[locType].act();
                        MinersDelight.itemMap[this.x][this.y] = 14;
                    }
                } else if (locType != 11 && locType != 14) {
                    Item.itemTypes[locType].act();
                    MinersDelight.itemMap[this.x][this.y] = 0;
                }
            }
            if (MinersDelight.Map[this.x][this.y] == 8 && MinersDelight.doorKey) {
                MinersDelight.nextGame();
            }
        }
    }

    public void isPlayer() {
        this.Player = true;
    }

    public int[] getPlannedLoc() {
        return new int[]{this.planX, this.planY};
    }

    public int[] getLoc() {
        int[] re = new int[]{this.x, this.y, this.direction};
        if (this.xOffSet >= 0.5) {
            re[0] = re[0] + 1;
        } else if (this.xOffSet < -0.5) {
            re[0] = re[0] - 1;
        }
        if (this.yOffSet >= 0.5) {
            re[1] = re[1] + 1;
        } else if (this.yOffSet < -0.5) {
            re[1] = re[1] - 1;
        }
        return re;
    }

    public int getHealth() {
        return this.health;
    }

    public void addHealth(int i) {
        this.health += i;
    }

    public void fullHealth() {
        this.health = this.maxHealth;
    }

    public void setDrawType(int d) {
        this.drawType = d;
    }

    public void draw(Graphics g) {
        switch (this.drawType) {
            case 0: {
                g.drawImage(this.img[this.direction][this.state], (int)(((double)this.x + this.xOffSet) * 40.0), (int)(((double)this.y + this.yOffSet) * 40.0), null);
                break;
            }
            case 1: {
                if (this.action == 2) {
                    g.drawImage(this.img[this.direction][(int)(MinersDelight.currentTime % 40000L) / 50 % 4], (int)(((double)this.x + this.xOffSet) * 40.0), (int)(((double)this.y + this.yOffSet) * 40.0), null);
                    break;
                }
                g.drawImage(this.img[this.direction][(int)(MinersDelight.currentTime % 40000L) / 150 % 4], (int)(((double)this.x + this.xOffSet) * 40.0), (int)(((double)this.y + this.yOffSet) * 40.0), null);
            }
        }
    }

    public void drawHealth(int x, int y, Graphics g) {
        for (int i = 0; i < this.maxHealth; ++i) {
            if (i < this.health) {
                g.drawImage(Sprite.hearts[0][0], x + i * 26, y, null);
                continue;
            }
            g.drawImage(Sprite.hearts[1][0], x + i * 26, y, null);
        }
    }

    public static Actor newEnemy_Slime(int xx, int yy) {
        Actor re = new Actor(Sprite.slimeSprite, xx, yy, 2);
        re.setDrawType(1);
        return re;
    }
}

