/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import javax.imageio.ImageIO;
import src.MinersDelight;

public class Sprite {
    public static Image menu = Sprite.getbuff("teststartmenu.png");
    public static Image menuover = Sprite.getbuff("menuover.png");
    public static Image gameOver = Sprite.getbuff("gameover.png");
    public static Image dirt = Sprite.getbuff("dirt2.png");
    public static Image dirtwallL = Sprite.getbuff("dirtwalllower.png");
    public static Image dirtwallLt = Sprite.getbuff("dirtwalllowest.png");
    public static Image dirtwallU = Sprite.getbuff("dirtwallupper.png");
    public static Image stonewallL = Sprite.getbuff("stonewalllower.png");
    public static Image stonewallU = Sprite.getbuff("stonewallupper.png");
    public static Image blackwallL = Sprite.getbuff("blackwalllower.png");
    public static Image blackwallU = Sprite.getbuff("blackwallupper.png");
    public static Image grassLt = Sprite.getbuff("grasslowest2.png");
    public static Image grassL = Sprite.getbuff("grasslower.png");
    public static Image grassU = Sprite.getbuff("grassupper.png");
    public static Image[] gems = new Image[]{Sprite.getbuff("gemswall1.png"), Sprite.getbuff("gemswall2.png"), Sprite.getbuff("gemswall3.png")};
    public static Image[][] playerSprite = Sprite.imaging(Sprite.getbuff("baseplayer.png"), 40, 40);
    public static Image[][] itemSprites = Sprite.imaging(Sprite.getbuff("items.png"), 40, 40);
    public static Image[][] numbers = Sprite.imaging(Sprite.getbuff("numbers.png"), 16, 23);
    public static Image[][] numback = Sprite.imaging(Sprite.getbuff("numback.png"), 16, 29);
    public static Image infoback = Sprite.getbuff("infoback.png");
    public static Image doorclosed = Sprite.getbuff("doorclosed.png");
    public static Image[][] hearts = Sprite.imaging(Sprite.getbuff("hearts.png"), 24, 22);
    public static Image[][] shroud = Sprite.imaging(Sprite.getbuff("shadows.png"), 40, 40);
    public static Image[][] slimeSprite = Sprite.imaging(Sprite.getbuff("slime.png"), 40, 40);

    public static BufferedImage getbuff(String s) {
        try {
            return ImageIO.read(Sprite.class.getResource(s));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Image sprite(int XX, int YY, int WW, int HH, BufferedImage B) {
        return B.getSubimage(XX, YY, WW, HH);
    }

    public static Image horizontalflip(int XX, int YY, int WW, int HH, BufferedImage B) {
        BufferedImage temp = B.getSubimage(XX, YY, WW, HH);
        int w = temp.getWidth();
        int h = temp.getHeight();
        BufferedImage dimg = new BufferedImage(w, h, temp.getType());
        Graphics2D g = dimg.createGraphics();
        g.drawImage(temp, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage[][] horizontalflipSet(BufferedImage[][] b) {
        BufferedImage[][] c = new BufferedImage[b.length][b[0].length];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < b[0].length; ++j) {
                c[i][j] = (BufferedImage)Sprite.horizontalflip(0, 0, 16, 16, b[i][j]);
            }
        }
        return c;
    }

    public static BufferedImage[][] imaging(BufferedImage I, int xx, int yy) {
        BufferedImage[][] RETURN = new BufferedImage[I.getWidth() / xx][I.getHeight() / yy];
        for (int X = 0; X < I.getWidth() / xx; ++X) {
            for (int Y = 0; Y < I.getHeight() / yy; ++Y) {
                RETURN[X][Y] = (BufferedImage)Sprite.sprite(X * xx, Y * yy, xx, yy, I);
            }
        }
        return RETURN;
    }

    public static Image Rotate(Image img, double H, double K, double degree) {
        degree = -degree;
        int dtest = 1 - (int)Math.toRadians(degree * 4.0);
        int w = img.getWidth(MinersDelight.Start);
        int h = img.getHeight(MinersDelight.Start);
        int[] pixels = new int[w * h];
        int[] newpixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        for (double yy = 0.0; yy < (double)h; yy += 1.0) {
            for (double xx = 0.0; xx < (double)w; xx += 1.0) {
                int[] color = new int[]{0, 0, 0, 0};
                int pixel = 0;
                double newx = (xx - H) * Math.cos(Math.toRadians(degree)) - (yy - K) * Math.sin(Math.toRadians(degree)) + H;
                double newy = (xx - H) * Math.sin(Math.toRadians(degree)) + (yy - K) * Math.cos(Math.toRadians(degree)) + K;
                if (Math.round(newx) >= 0L && Math.round(newx) < (long)w && Math.round(newy) >= 0L && Math.round(newy) < (long)h) {
                    pixel = pixels[(int)(Math.round(newy) * (long)w + Math.round(newx))];
                    color = new int[]{pixel >> 24 & 0xFF, pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF};
                }
                newpixels[(int)(Math.round((double)yy) * (long)w + Math.round((double)xx))] = color[0] << 24 | color[1] << 16 | color[2] << 8 | color[3];
            }
        }
        return Sprite.getImageFromArray(newpixels, w, h);
    }

    public static Image getImageFromArray(int[] pixels, int width, int height) {
        return MinersDelight.Start.createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }
}

