/*
 * Decompiled with CFR 0.152.
 */
package Xoblun.TinyFish;

import Xoblun.TinyFish.CircleObject;
import Xoblun.TinyFish.TinyFish;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

abstract class Actor {
    double angle = 0.0;
    double momentumAngle = 0.0;
    double momentum = 0.0;
    double radius;
    double speed = 10.0;
    public double xLoc;
    public double yLoc;
    double weight = 0.3;
    double pushAngle = 0.0;
    double pushPower = 0.0;
    int type = 0;
    int hurt = 0;
    public int health = 3;
    public int maxHealth = 3;
    public boolean enemy = false;
    public int ActorLocation = -1;
    double gravity = 0.0;

    Actor() {
    }

    public void setLoc(double x, double y) {
        this.xLoc = x;
        this.yLoc = y;
    }

    public void setAngle(double a) {
        this.angle = (a + 360.0) % 360.0;
    }

    public void setAsEnemy() {
        this.enemy = true;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public abstract void AI();

    public void act() {
        double atest;
        boolean test;
        if (this.hurt > 0) {
            --this.hurt;
        }
        boolean bl = test = TinyFish.calcDist(0.0, 0.0, this.xLoc, this.yLoc) > TinyFish.worldRadius;
        if (test) {
            atest = TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc);
            this.gravity += this.weight;
            if (this.gravity > 50.0) {
                this.gravity = 30.0;
            }
            double[] locs = TinyFish.Rotate(this.xLoc, this.yLoc - this.gravity, this.xLoc, this.yLoc, (atest + 180.0) % 360.0);
            this.xLoc = locs[0];
            this.yLoc = locs[1];
        } else {
            this.gravity -= 1.0;
            if (this.gravity < 0.0) {
                this.gravity = 0.0;
            } else {
                atest = TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc);
                double[] locs = TinyFish.Rotate(this.xLoc, this.yLoc - this.gravity, this.xLoc, this.yLoc, (atest + 180.0) % 360.0);
                this.xLoc = locs[0];
                this.yLoc = locs[1];
            }
        }
        double[] locs = TinyFish.Rotate(this.xLoc, this.yLoc - this.momentum, this.xLoc, this.yLoc, this.momentumAngle);
        this.xLoc = locs[0];
        this.yLoc = locs[1];
        if (!test) {
            this.momentum -= this.speed / 20.0;
        }
        if (this.momentum < 0.0) {
            this.momentum = 0.0;
        }
        if (this.momentum > this.speed) {
            this.momentum = this.speed;
        }
    }

    public void checkForDead() {
        if (this.ActorLocation == -1) {
            return;
        }
        if (this.ActorLocation == -2) {
            if (TinyFish.player.health <= 0) {
                this.ActorLocation = -1;
            }
        } else if (TinyFish.fishies.get((int)this.ActorLocation).health <= 0) {
            this.ActorLocation = -1;
        }
    }

    public void deheal() {
        if (this.hurt > 0) {
            return;
        }
        this.hurt = 100;
        --this.health;
    }

    public void attack() {
        if (this.health <= 0) {
            return;
        }
        if (this.enemy) {
            double ang;
            double angdiff;
            double[] dArray = new double[]{this.xLoc, this.yLoc, this.radius / this.speed * this.momentum};
            double[] dArray2 = new double[]{TinyFish.player.xLoc, TinyFish.player.yLoc, TinyFish.player.getRadius()};
            double dist = TinyFish.CircleCollision(dArray, dArray2);
            if (dist > 0.0 && (angdiff = (this.angle + (180.0 - (ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc))) + 360.0 + 360.0 + 360.0) % 360.0) >= 120.0 && angdiff <= 240.0) {
                this.momentum /= 2.0;
                TinyFish.player.deheal();
            }
        }
        for (Actor a : TinyFish.fishies) {
            double ang;
            double angdiff;
            if (this.enemy == a.enemy || a == this) continue;
            double[] dArray = new double[]{this.xLoc, this.yLoc, this.radius / this.speed * this.momentum};
            double[] dArray3 = new double[]{a.xLoc, a.yLoc, a.getRadius()};
            double dist = TinyFish.CircleCollision(dArray, dArray3);
            if (!(dist > 0.0) || !((angdiff = (this.angle + (180.0 - (ang = TinyFish.calcAngle(this.xLoc, this.yLoc, a.xLoc, a.yLoc))) + 360.0 + 360.0 + 360.0) % 360.0) >= 120.0) || !(angdiff <= 240.0)) continue;
            this.momentum /= 2.0;
            if (a.ActorLocation == -1) {
                a.ActorLocation = TinyFish.fishies.indexOf(this);
            }
            if (this == TinyFish.player) {
                a.ActorLocation = -2;
            }
            a.deheal();
        }
    }

    public void push() {
        if (this.pushPower == 0.0) {
            return;
        }
        double[] locs = TinyFish.Rotate(this.xLoc, this.yLoc - this.pushPower, this.xLoc, this.yLoc, this.pushAngle);
        this.xLoc = locs[0];
        this.yLoc = locs[1];
        this.pushPower = 0.0;
    }

    public void setupPush() {
        double dist;
        this.pushAngle = 0.0;
        this.pushPower = 0.0;
        for (CircleObject circleObject : TinyFish.rockies) {
            double[] dArray = new double[]{this.xLoc, this.yLoc, this.radius};
            double[] dArray2 = new double[]{circleObject.xLoc, circleObject.yLoc, circleObject.getRadius()};
            dist = TinyFish.CircleCollision(dArray, dArray2);
            if (!(dist > 0.0)) continue;
            this.pushPower = dist + 1.0;
            this.pushAngle = (TinyFish.calcAngle(this.xLoc, this.yLoc, circleObject.xLoc, circleObject.yLoc) + 180.0) % 360.0;
            this.momentum /= 1.0 + dist / 100.0;
            return;
        }
        if (TinyFish.player != this) {
            double[] dArray = new double[]{this.xLoc, this.yLoc, this.radius};
            double[] dArray3 = new double[]{TinyFish.player.xLoc, TinyFish.player.yLoc, TinyFish.player.getRadius()};
            double dist2 = TinyFish.CircleCollision(dArray, dArray3);
            if (dist2 > 0.0) {
                this.pushPower = dist2 / 2.0;
                this.pushAngle = (TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc) + 180.0) % 360.0;
                this.momentum /= 1.0 + dist2 / 100.0;
                return;
            }
        }
        for (Actor actor : TinyFish.fishies) {
            if (actor == this) continue;
            double[] dArray = new double[]{this.xLoc, this.yLoc, this.radius};
            double[] dArray4 = new double[]{actor.xLoc, actor.yLoc, actor.getRadius()};
            dist = TinyFish.CircleCollision(dArray, dArray4);
            if (!(dist > 0.0)) continue;
            this.pushPower = dist / 2.0;
            this.pushAngle = (TinyFish.calcAngle(this.xLoc, this.yLoc, actor.xLoc, actor.yLoc) + 180.0) % 360.0;
            this.momentum /= 1.0 + dist / 100.0;
            break;
        }
    }

    public void Rotate(double a) {
        this.angle += (a + 360.0) % 360.0;
    }

    public void forward() {
        this.momentum += this.speed / 10.0;
        this.momentumAngle = this.angle;
        if (this.momentum > this.speed) {
            this.momentum = this.speed;
        }
    }

    public void drawOver(Graphics g, int xShift, int yShift) {
        if (this.hurt % 2 == 1) {
            return;
        }
        if (this.xLoc - (double)xShift - 50.0 > (double)TinyFish.width + this.radius * 3.0 || this.xLoc - (double)xShift - 50.0 < -this.radius * 3.0 || this.yLoc - (double)yShift - 50.0 > (double)TinyFish.height + this.radius * 3.0 || this.yLoc - (double)yShift - 50.0 < -this.radius * 3.0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        int use = (int)Math.floor((this.angle + 45.0 + 360.0 - TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)) % 360.0 / 90.0);
        double W = (double)this.getSpriteUnder()[use][this.type].getWidth(null) / 2.0;
        AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians((this.angle + 45.0 + 360.0 - TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)) % 90.0 - 45.0 + TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)), W, W);
        AffineTransformOp op = new AffineTransformOp(tx, null);
        g2d.drawImage((Image)op.filter(this.getSpriteOver()[use][this.type], null), (int)(this.xLoc - (double)xShift - W + Math.sin((double)System.currentTimeMillis() / 700.0 + this.yLoc / 100.0) * 3.0), (int)(this.yLoc - (double)yShift - W + Math.cos((double)System.currentTimeMillis() / 600.0 + this.xLoc / 100.0) * 3.0), null);
    }

    public void drawUnder(Graphics g, int xShift, int yShift) {
        if (this.hurt != 0 && this.hurt % 2 == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        int use = (int)Math.floor((this.angle + 45.0 + 360.0 - TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)) % 360.0 / 90.0);
        double W = (double)this.getSpriteUnder()[use][this.type].getWidth(null) / 2.0;
        AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians((this.angle + 45.0 + 360.0 - TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)) % 90.0 - 45.0 + TinyFish.calcAngle(0.0, 0.0, this.xLoc, this.yLoc)), W, W);
        AffineTransformOp op = new AffineTransformOp(tx, null);
        g2d.drawImage((Image)op.filter(this.getSpriteUnder()[use][this.type], null), (int)(this.xLoc - (double)xShift - W + Math.sin((double)System.currentTimeMillis() / 700.0 + this.yLoc / 100.0) * 3.0), (int)(this.yLoc - (double)yShift - W + Math.cos((double)System.currentTimeMillis() / 600.0 + this.xLoc / 100.0) * 3.0), null);
    }

    public abstract BufferedImage[][] getSpriteOver();

    public abstract BufferedImage[][] getSpriteUnder();
}

