/*
 * Decompiled with CFR 0.152.
 */
package Xoblun.TinyFish;

import Xoblun.TinyFish.Actor;
import Xoblun.TinyFish.Sprite;
import Xoblun.TinyFish.TinyFish;
import java.awt.image.BufferedImage;

class SmallFish
extends Actor {
    public SmallFish(double x, double y) {
        this.radius = 20.0;
        this.xLoc = x;
        this.yLoc = y;
    }

    public SmallFish(double x, double y, int t) {
        this.radius = 20.0;
        this.xLoc = x;
        this.yLoc = y;
        this.type = t;
    }

    @Override
    public void AI() {
        double dist = TinyFish.calcDist(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc);
        double ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc);
        if (dist > this.radius + 50.0 && TinyFish.player.getMomentum() > dist / 30.0 || this.hurt > 0) {
            this.forward();
        }
        if (this.hurt > 0) {
            if (this.ActorLocation != -1) {
                ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.fishies.get((int)this.ActorLocation).xLoc, TinyFish.fishies.get((int)this.ActorLocation).yLoc);
                if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 >= 180.0) {
                    this.Rotate(5.0);
                } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 <= 180.0) {
                    this.Rotate(-5.0);
                }
            }
        } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 > 200.0) {
            this.Rotate(-5.0);
        } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 < 160.0) {
            this.Rotate(5.0);
        }
    }

    @Override
    public BufferedImage[][] getSpriteOver() {
        return Sprite.basicFishOver;
    }

    @Override
    public BufferedImage[][] getSpriteUnder() {
        return Sprite.basicFishUnder;
    }
}

