/*
 * Decompiled with CFR 0.152.
 */
package Xoblun.TinyFish;

import Xoblun.TinyFish.Actor;
import Xoblun.TinyFish.CircleObject;
import Xoblun.TinyFish.Rock;
import Xoblun.TinyFish.SmallFish;
import Xoblun.TinyFish.Sprite;
import Xoblun.TinyFish.enemyFish;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;

public class TinyFish
extends JFrame
implements KeyListener,
MouseListener,
MouseMotionListener {
    public static TinyFish Start;
    Image img;
    Image backImg;
    Graphics graph;
    public static int width;
    public static int height;
    public static int cameraViewX;
    public static int cameraViewY;
    public static Actor player;
    public static ArrayList<CircleObject> rockies;
    public static ArrayList<Actor> fishies;
    public static int gameState;
    public static double worldRadius;
    public static int enemiesToAdd;
    public static int enemyCount;
    public static int score;
    long previousTime;
    long currentTime2;
    long frameCount = 0L;
    boolean started = false;
    public static double fps;
    public static long currentTime;
    int TT = 0;
    double avg = 0.0;
    double test = 0.0;
    double every = 0.0;
    long total = 1L;
    long all = 0L;
    long totaltotal = 0L;
    double totalavg = 0.0;
    public long W = System.currentTimeMillis();
    int fpsnum = 10;
    public static int change;
    private int mouseX = 0;
    private int mouseY = 0;
    private int mouseDownX = 0;
    private int mouseDownY = 0;
    private int mouseClick = 0;

    public static void main(String[] args) {
        Start = new TinyFish();
    }

    public TinyFish() {
        this.setTitle("TinyFish");
        this.setSize(width, height);
        this.setResizable(false);
        this.setBackground(Color.BLACK);
        this.setDefaultCloseOperation(3);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.started) {
            this.img = this.createImage(width, height);
            this.graph = this.img.getGraphics();
            this.started = true;
        }
        currentTime = System.currentTimeMillis();
        this.test = System.currentTimeMillis();
        long W = System.currentTimeMillis() + (long)this.fpsnum;
        switch (gameState) {
            case 0: {
                this.paintMenu(this.graph);
                break;
            }
            case 1: {
                this.updateControls();
                this.update();
                this.paintComponent(this.graph);
                this.paintClouds(this.graph);
                this.paintScore(this.graph, 25, 25);
                break;
            }
            case 2: {
                Graphics2D g2d = (Graphics2D)this.graph;
                g2d.setColor(new Color(12047074));
                g2d.fillRect(0, 0, width, height);
                this.graph.drawImage(Sprite.aboutPage, 0, 0, null);
                break;
            }
            case 3: {
                this.graph.drawImage(Sprite.gameOverPage, 0, 0, null);
                this.paintScore(this.graph, 220, 410);
            }
        }
        g.drawImage(this.img, 0, 0, this);
        long W2 = System.currentTimeMillis();
        if (W - W2 > 0L) {
            TinyFish.WAIT(W - W2);
        }
        this.test = (double)System.currentTimeMillis() - this.test;
        this.every += this.test;
        if (this.test > 33.0) {
            --this.fpsnum;
        }
        if (this.test < 33.0) {
            ++this.fpsnum;
        }
        if (this.fpsnum < 0) {
            this.fpsnum = 0;
        }
        this.avg += (this.test - this.avg) / (double)(++this.all);
        if (this.every >= 1000.0) {
            this.totalavg += (this.avg - this.totalavg) / (double)(++this.totaltotal);
            fps = 1000.0 / this.avg;
            this.every -= 1000.0;
            this.all = 0L;
            this.avg = 0.0;
        }
        ++this.frameCount;
        this.currentTime2 = System.currentTimeMillis();
        if (this.currentTime2 - this.previousTime >= 1000L) {
            this.previousTime = this.currentTime2;
            System.out.println("==> " + this.frameCount);
            this.frameCount = 0L;
        }
        this.repaint();
    }

    public static void WAIT(long m) {
        try {
            Thread.sleep(m);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void paintMenu(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(12047074));
        g2d.fillRect(0, 0, width, height);
        AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(Math.sin((double)System.currentTimeMillis() / 700.0) * 3.0), (double)width / 2.0, (double)height / 2.0);
        AffineTransformOp op = new AffineTransformOp(tx, null);
        g.drawImage(op.filter(Sprite.menu, null), (int)(Math.sin((double)System.currentTimeMillis() / 670.0) * 5.0), (int)(Math.cos((double)System.currentTimeMillis() / 670.0) * 5.0), null);
        int sOver = TinyFish.pointToRect(this.mouseX, this.mouseY, 40 + change, 450 + change, Sprite.startButton.getWidth(null) - change * 2, Sprite.startButton.getHeight(null) - change * 2) ? 0 : change;
        g.drawImage(Sprite.startButton, 40 + sOver, 450 + sOver, Sprite.startButton.getWidth(null) - sOver * 2, Sprite.startButton.getHeight(null) - sOver * 2, null);
        sOver = TinyFish.pointToRect(this.mouseX, this.mouseY, 460 + change, 450 + change, Sprite.aboutButton.getWidth(null) - change * 2, Sprite.aboutButton.getHeight(null) - change * 2) ? 0 : change;
        g.drawImage(Sprite.aboutButton, 460 + sOver, 450 + sOver, Sprite.aboutButton.getWidth(null) - sOver * 2, Sprite.aboutButton.getHeight(null) - sOver * 2, null);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(12047074));
        g2d.fillRect(0, 0, width, height);
        this.paintWorld((Graphics2D)g);
        for (int i = 0; i < 4; ++i) {
            for (CircleObject a : rockies) {
                a.draw(g, cameraViewX, cameraViewY, i);
            }
        }
        for (Actor a : fishies) {
            a.drawUnder(g, cameraViewX, cameraViewY);
        }
        player.drawUnder(g, cameraViewX, cameraViewY);
        for (Actor a : fishies) {
            a.drawOver(g, cameraViewX, cameraViewY);
        }
        player.drawOver(g, cameraViewX, cameraViewY);
        this.paintHealth(g);
    }

    public void paintWorld(Graphics2D g2d) {
        double rtest = worldRadius;
        g2d.setColor(new Color(3488144));
        g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) - rtest, (double)(-cameraViewY) - rtest, rtest * 2.0, rtest * 2.0));
        rtest = rtest / 100.0 * 98.0;
        g2d.setColor(new Color(5337519));
        g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) - rtest, (double)(-cameraViewY) - rtest, rtest * 2.0, rtest * 2.0));
        rtest = rtest / 100.0 * 95.0;
        g2d.setColor(new Color(8299979));
        g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) - rtest, (double)(-cameraViewY) - rtest, rtest * 2.0, rtest * 2.0));
        rtest = rtest / 100.0 * 75.0;
        g2d.setColor(new Color(5004179));
        g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) - rtest, (double)(-cameraViewY) - rtest, rtest * 2.0, rtest * 2.0));
        rtest = rtest / 100.0 * 60.0;
        g2d.setColor(new Color(3162234));
        g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) - rtest, (double)(-cameraViewY) - rtest, rtest * 2.0, rtest * 2.0));
    }

    public void paintHealth(Graphics g) {
        g.drawImage(Sprite.healthBar[0][0], 300, 400, null);
        for (int i = 0; i < TinyFish.player.health; ++i) {
            g.drawImage(Sprite.healthBar[i + 1][0], 300, 400, null);
        }
    }

    public void paintScore(Graphics g, int x, int y) {
        int i;
        String s = "" + score;
        for (i = 0; i < 6; ++i) {
            g.drawImage(Sprite.scoreSprites[i][0], x + i * 50, y, null);
        }
        for (i = 0; i < s.length(); ++i) {
            int n = s.charAt(i) - 49 + 7;
            g.drawImage(Sprite.scoreSprites[n][0], x + (i + 6) * 50, y, null);
        }
    }

    public void paintClouds(Graphics g) {
        double s;
        double[] locs;
        int j;
        int i;
        double angleToDraw = (double)System.currentTimeMillis() / 1000.0 % 360.0;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(new Color(0xBBBBBB));
        for (i = 0; i < 6; ++i) {
            for (j = -2; j <= 2; ++j) {
                locs = TinyFish.Rotate(0.0, -1200.0, 0.0, 0.0, angleToDraw + (double)(i * 60) + (double)j * 1.8);
                s = 40.0 - Math.abs((double)j * 7.0 * (1.0 + (double)j / 10.0));
                g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) + locs[0] - s, (double)(-cameraViewY) + locs[1] - s, s * 2.0, s * 2.0));
            }
        }
        g2d.setColor(new Color(0xEEEEEE));
        for (i = 0; i < 6; ++i) {
            for (j = -2; j <= 2; ++j) {
                locs = TinyFish.Rotate(0.0, -1200.0, 0.0, 0.0, angleToDraw + (double)(i * 60) + (double)j * 1.8);
                s = 40.0 - Math.abs((double)j * 7.0 * (1.0 + (double)j / 10.0)) - 3.0;
                g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) + locs[0] - s, (double)(-cameraViewY) + locs[1] - s, s * 2.0, s * 2.0));
            }
        }
        angleToDraw = (angleToDraw + 25.0) % 360.0;
        g2d.setColor(new Color(0xBBBBBB));
        for (i = 0; i < 6; ++i) {
            for (j = -1; j <= 1; ++j) {
                locs = TinyFish.Rotate(0.0, -1200.0, 0.0, 0.0, angleToDraw + (double)(i * 60) + (double)(j * 1));
                s = 40.0 - Math.abs((double)j * 7.0 * (1.0 + (double)j / 10.0)) - 10.0;
                g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) + locs[0] - s, (double)(-cameraViewY) + locs[1] - s, s * 2.0, s * 2.0));
            }
        }
        g2d.setColor(new Color(0xEEEEEE));
        for (i = 0; i < 6; ++i) {
            for (j = -1; j <= 1; ++j) {
                locs = TinyFish.Rotate(0.0, -1200.0, 0.0, 0.0, angleToDraw + (double)(i * 60) + (double)(j * 1));
                s = 40.0 - Math.abs((double)j * 7.0 * (1.0 + (double)j / 10.0)) - 13.0;
                g2d.fill(new Ellipse2D.Double((double)(-cameraViewX) + locs[0] - s, (double)(-cameraViewY) + locs[1] - s, s * 2.0, s * 2.0));
            }
        }
    }

    public void update() {
        this.addEnemies();
        this.updateAI();
        this.updateAct();
        this.updateAttack();
        this.updateDeads();
        this.updateSetupPush();
        this.updatePush();
        this.updateSetupPush();
        this.updatePush();
        this.updateSetupPush();
        this.updatePush();
        this.updateSetupPush();
        this.updatePush();
        this.updateSetupPush();
        this.updatePush();
        this.updateSetupPush();
        this.updatePush();
        this.updateCamera();
        if (TinyFish.player.health <= 0) {
            gameState = 3;
            this.mouseClick = 0;
        }
    }

    public void addEnemies() {
        for (int i = 0; i < enemiesToAdd; ++i) {
            Random r = new Random();
            double[] locs = TinyFish.Rotate(0.0, -2000.0, 0.0, 0.0, (double)r.nextInt(360) + r.nextDouble());
            fishies.add(new enemyFish(locs[0], locs[1], enemyCount++ % 3));
            fishies.get(fishies.size() - 1).setAsEnemy();
        }
        enemiesToAdd = 0;
    }

    public void updateAttack() {
        player.attack();
        for (Actor a : fishies) {
            a.attack();
        }
    }

    public void updateControls() {
        if (this.mouseClick == 1) {
            player.forward();
        }
    }

    public void updateDeads() {
        for (Actor a : fishies) {
            a.checkForDead();
        }
        int s = fishies.size();
        for (int i = 0; i < s; ++i) {
            if (TinyFish.fishies.get((int)i).health > 0) continue;
            if (TinyFish.fishies.get((int)i).enemy) {
                ++enemiesToAdd;
                ++score;
            }
            fishies.remove(i);
            for (Actor a : fishies) {
                if (a.ActorLocation <= i) continue;
                --a.ActorLocation;
            }
            --i;
            --s;
        }
    }

    public void updateAI() {
        for (Actor a : fishies) {
            a.AI();
        }
    }

    public void updateAct() {
        player.act();
        for (Actor a : fishies) {
            a.act();
        }
    }

    public void updateSetupPush() {
        player.setupPush();
        for (Actor a : fishies) {
            a.setupPush();
        }
    }

    public void updatePush() {
        player.push();
        for (Actor a : fishies) {
            a.push();
        }
    }

    public void updateCamera() {
        cameraViewX = (int)((TinyFish.player.xLoc + (double)this.mouseX - (double)width + (double)cameraViewX) / 2.0);
        cameraViewY = (int)((TinyFish.player.yLoc + (double)this.mouseY - (double)height + (double)cameraViewY) / 2.0);
        cameraViewX = (int)(TinyFish.player.xLoc / 2.0 + (double)cameraViewX / 2.0 - (double)width / 4.0);
        cameraViewY = (int)(TinyFish.player.yLoc / 2.0 + (double)cameraViewY / 2.0 - (double)height / 4.0);
    }

    public static void newWorld() {
        int i;
        enemiesToAdd = 3;
        score = 0;
        rockies = new ArrayList();
        fishies = new ArrayList();
        Random r = new Random();
        double[] locsplayer = TinyFish.Rotate(0.0, (double)(-r.nextInt(600)) - r.nextDouble() - 300.0, 0.0, 0.0, (double)r.nextInt(360) + r.nextDouble());
        player = new SmallFish(locsplayer[0], locsplayer[1]);
        rockies.add(new Rock(0.0, 0.0, 250.0));
        for (i = 0; i < 15; ++i) {
            double rad = r.nextInt(60) + 10;
            double[] locs = TinyFish.Rotate(0.0, (double)(-r.nextInt(500)) - r.nextDouble() - 300.0, 0.0, 0.0, (double)r.nextInt(360) + r.nextDouble());
            rockies.add(new Rock(locs[0], locs[1], rad));
        }
        for (i = 0; i < 25; ++i) {
            double[] locs = TinyFish.Rotate(0.0, (double)(-r.nextInt(600)) - r.nextDouble() - 300.0, 0.0, 0.0, (double)r.nextInt(360) + r.nextDouble());
            fishies.add(new SmallFish(locs[0], locs[1], i % 3 + 1));
        }
    }

    public static boolean pointToRect(int x, int y, int rectX, int rectY, int rectW, int rectH) {
        return x > rectX && x < rectX + rectW && y > rectY && y < rectY + rectH;
    }

    public static double calcAngle(double x1, double y1, double x2, double y2) {
        return (Math.toDegrees(Math.atan2(y1 - y2, x1 - x2)) + 270.0) % 360.0;
    }

    public static double CircleCollision(double[] a, double[] b) {
        return -TinyFish.calcDist(a[0], a[1], b[0], b[1]) + a[2] + b[2];
    }

    public static double calcDist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((y1 - y2) * (y1 - y2) + (x1 - x2) * (x1 - x2));
    }

    public static double[] Rotate(double x, double y, double H, double K, double degree) {
        double newx = (x - H) * Math.cos(Math.toRadians(degree)) - (y - K) * Math.sin(Math.toRadians(degree)) + H;
        double newy = (x - H) * Math.sin(Math.toRadians(degree)) + (y - K) * Math.cos(Math.toRadians(degree)) + K;
        return new double[]{newx, newy};
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.mouseClick = e.getButton();
        switch (this.mouseClick) {
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                this.mouseDownX = this.mouseX;
                this.mouseDownY = this.mouseY;
            }
        }
        switch (gameState) {
            case 0: {
                if (TinyFish.pointToRect(this.mouseX, this.mouseY, 40 + change, 450 + change, Sprite.startButton.getWidth(null) - change * 2, Sprite.startButton.getHeight(null) - change * 2)) {
                    gameState = 1;
                    TinyFish.newWorld();
                    break;
                }
                if (!TinyFish.pointToRect(this.mouseX, this.mouseY, 460 + change, 450 + change, Sprite.startButton.getWidth(null) - change * 2, Sprite.startButton.getHeight(null) - change * 2)) break;
                gameState = 2;
                this.mouseClick = 0;
                break;
            }
            case 2: 
            case 3: {
                if (e.getButton() == 0) break;
                gameState = 0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseClick = 0;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        player.setAngle(TinyFish.calcAngle((double)width / 2.0, (double)height / 2.0, this.mouseX, this.mouseY));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        player.setAngle(TinyFish.calcAngle((double)width / 2.0, (double)height / 2.0, this.mouseX, this.mouseY));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                gameState = 0;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static {
        width = 800;
        height = 600;
        cameraViewX = 0;
        cameraViewY = 0;
        player = new SmallFish(100.0, 100.0);
        rockies = new ArrayList();
        fishies = new ArrayList();
        gameState = 0;
        worldRadius = 1000.0;
        enemiesToAdd = 3;
        enemyCount = 0;
        score = 0;
        fps = 30.0;
        currentTime = 0L;
        change = 15;
    }
}

