/*
 * Decompiled with CFR 0.152.
 */
package Xoblun.TinyFish;

import Xoblun.TinyFish.Actor;
import Xoblun.TinyFish.Sprite;
import Xoblun.TinyFish.TinyFish;
import java.awt.image.BufferedImage;

class enemyFish
extends Actor {
    public enemyFish(double x, double y, int t) {
        switch (t) {
            case 0: {
                this.radius = 35.0;
                this.speed = 13.0;
                this.weight = 0.6;
                this.health = 4;
                this.maxHealth = 4;
                break;
            }
            case 1: {
                this.radius = 68.0;
                this.speed = 7.0;
                this.weight = 0.8;
                this.health = 6;
                this.maxHealth = 6;
                break;
            }
            case 2: {
                this.radius = 35.0;
                this.speed = 18.0;
                this.weight = 0.4;
                break;
            }
            default: {
                this.radius = 35.0;
            }
        }
        this.xLoc = x;
        this.yLoc = y;
        this.type = t;
    }

    @Override
    public void AI() {
        if (this.enemy) {
            this.enemyAI();
            return;
        }
        double dist = TinyFish.calcDist(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc);
        double ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc);
        if (dist > this.radius + 50.0 && TinyFish.player.getMomentum() > dist / 30.0 || this.hurt > 0) {
            this.forward();
        }
        if (dist > 600.0) {
            if (this.hurt > 0 && this.ActorLocation != -1) {
                ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.fishies.get((int)this.ActorLocation).xLoc, TinyFish.fishies.get((int)this.ActorLocation).yLoc);
                if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 180.0) % 360.0 > 200.0) {
                    this.Rotate(-5.0);
                } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 180.0) % 360.0 < 160.0) {
                    this.Rotate(5.0);
                }
            }
            return;
        }
        if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 > 200.0) {
            this.Rotate(-5.0);
        } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 < 160.0) {
            this.Rotate(5.0);
        }
    }

    public void enemyAI() {
        if (this.ActorLocation == -1) {
            this.getNewTarget();
        }
        if (this.ActorLocation == -1) {
            return;
        }
        if (this.ActorLocation == -2) {
            double ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.player.xLoc, TinyFish.player.yLoc);
            this.forward();
            if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 > 200.0) {
                this.Rotate(-5.0);
            } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 < 160.0) {
                this.Rotate(5.0);
            }
        } else {
            double ang = TinyFish.calcAngle(this.xLoc, this.yLoc, TinyFish.fishies.get((int)this.ActorLocation).xLoc, TinyFish.fishies.get((int)this.ActorLocation).yLoc);
            this.forward();
            if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 > 200.0) {
                this.Rotate(-5.0);
            } else if ((this.angle + (180.0 - ang) + 360.0 + 360.0 + 360.0) % 360.0 < 160.0) {
                this.Rotate(5.0);
            }
        }
    }

    public void getNewTarget() {
        double theirDist = 1000.0;
        for (Actor a : TinyFish.fishies) {
            double dist;
            if (this.enemy == a.enemy || !((dist = TinyFish.calcDist(this.xLoc, this.yLoc, a.xLoc, a.yLoc)) <= 400.0) || !(dist < theirDist)) continue;
            this.ActorLocation = TinyFish.fishies.indexOf(a);
            theirDist = dist;
        }
    }

    @Override
    public BufferedImage[][] getSpriteOver() {
        return Sprite.enemyFishOver;
    }

    @Override
    public BufferedImage[][] getSpriteUnder() {
        return Sprite.enemyFishUnder;
    }
}

